<?php
require_once '../config/db.php';

// Get parameters
$product = $_GET['product'] ?? '';
$date = $_GET['date'] ?? '';

if (!$product || !$date) {
    echo json_encode(['success' => false, 'serials' => [], 'message' => 'Missing parameters']);
    exit;
}

// Try to find in supplier_receipts first (has serial_numbers as JSON)
$stmt = $pdo->prepare("
    SELECT serial_numbers 
    FROM supplier_receipts sr
    JOIN products p ON sr.product_id = p.id
    WHERE p.name = ? AND sr.created_at = ?
    LIMIT 1
");
$stmt->execute([$product, $date]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);

if ($row && !empty($row['serial_numbers'])) {
    $serials = json_decode($row['serial_numbers'], true);
    if (!is_array($serials)) $serials = [];
    echo json_encode(['success' => true, 'serials' => $serials]);
    exit;
}

// Try to find in stock_adjustments (if you store serials there)
$stmt = $pdo->prepare("
    SELECT serial_numbers 
    FROM stock_adjustments sa
    JOIN products p ON sa.product_id = p.id
    WHERE p.name = ? AND sa.adjusted_at = ?
    LIMIT 1
");
$stmt->execute([$product, $date]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);

if ($row && !empty($row['serial_numbers'])) {
    $serials = json_decode($row['serial_numbers'], true);
    if (!is_array($serials)) $serials = [];
    echo json_encode(['success' => true, 'serials' => $serials]);
    exit;
}

// No serials found
echo json_encode(['success' => true, 'serials' => []]); 